basic_stats <- function(reformatted, output_folder){
  require("survival")
  reformatted$censored <- as.numeric(reformatted$censored)
  fit <- survfit(Surv(time, censored) ~ condition, data = reformatted)
  survoutput<-summary(fit)$table
  write.csv(survoutput, paste(output_folder, "n_median_conf_intervals.csv", sep = "/"), row.names=TRUE)
  
  res <- summary(fit)
  cols <- lapply(c(2:6, 8:11) , function(x) res[x])
  tbl <- do.call(data.frame, cols)
  write.csv(tbl, paste(output_folder, "full_output_hazard_ratios.csv", sep = "/"), row.names=FALSE)
  
  logrank_test <- log_rank_all_groups(reformatted)
  write.csv(logrank_test, paste(output_folder, "logrank_stats.csv", sep = "/"), row.names=FALSE)
  
}